/*
 * Decompiled with CFR 0.152.
 */
package io.packagecloud.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.packagecloud.client.Client;
import io.packagecloud.client.Contents;
import io.packagecloud.client.Distributions;
import io.packagecloud.client.Package;
import io.packagecloud.client.Result;
import io.packagecloud.client.ServerErrorException;
import io.packagecloud.client.UnauthorizedException;
import java.io.IOException;
import java.util.Map;

public class PackageCloud {
    private final Client client;
    private final ObjectMapper mapper;

    public PackageCloud(Client configuredClient) {
        this.client = configuredClient;
        this.mapper = new ObjectMapper();
    }

    public Distributions getDistributions() throws UnauthorizedException, IOException, ServerErrorException {
        Result result = this.client.getDistributions();
        return (Distributions)this.mapper.readValue(result.getResponse(), Distributions.class);
    }

    public boolean putPackage(Package pkg) throws UnauthorizedException, IOException, ServerErrorException {
        this.client.putPackage(pkg.getFilestream(), pkg.getFilename(), pkg.getRepository(), pkg.getDistroVersionId(), pkg.getSourceFiles());
        return true;
    }

    public boolean putPackage(Package pkg, String username) throws UnauthorizedException, IOException, ServerErrorException {
        this.client.putPackage(pkg.getFilestream(), pkg.getFilename(), username, pkg.getRepository(), pkg.getDistroVersionId(), (Map)pkg.getSourceFiles());
        return true;
    }

    public Contents packageContents(Package pkg) throws Exception {
        Result result = this.client.packageContents(pkg.getFilestream(), pkg.getFilename(), pkg.getRepository());
        return (Contents)this.mapper.readValue(result.getResponse(), Contents.class);
    }
}

