/*
 * Decompiled with CFR 0.152.
 */
package io.packagecloud.client;

import io.packagecloud.client.LoggerProvider;
import java.util.logging.Logger;

public class Credentials
implements io.packagecloud.client.interfaces.Credentials {
    private static Logger logger = LoggerProvider.getLogger();
    private final String username;
    private final String token;

    public Credentials(String username, String token) {
        if (username == null) {
            throw new RuntimeException("username cannot be null");
        }
        if (token == null) {
            throw new RuntimeException("token cannot be null");
        }
        this.username = username;
        this.token = token;
        logger.info(String.format("%s/%s", username, this.getTokenForLogging()));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String getTokenForLogging() {
        String halfToken = this.token.substring(0, 4);
        return halfToken + new String(new char[20]).replace("\u0000", "*");
    }
}

