/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor.dialog;

import io.overcoded.grid.DialogType;
import io.overcoded.grid.processor.FieldCollector;
import io.overcoded.grid.processor.GridDialogValidator;
import io.overcoded.grid.processor.dialog.DialogTypeEvaluator;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DialogTypeDecider {
    private final FieldCollector fieldCollector;
    private final GridDialogValidator gridDialogValidator;
    private final List<DialogTypeEvaluator> dialogTypeEvaluators;

    public DialogType decide(Class<?> type, Class<?> parentType) {
        return this.fieldCollector.getFields(parentType).stream().filter(field -> this.getMatchingField((Field)field, type)).filter(this.gridDialogValidator::isDialogCandidate).map(this::toDialogType).filter(Optional::isPresent).map(Optional::get).findFirst().orElseGet(() -> this.decideReverse(type, parentType));
    }

    private DialogType decideReverse(Class<?> type, Class<?> parentType) {
        return this.fieldCollector.getFields(type).stream().filter(field -> this.getMatchingField((Field)field, parentType)).filter(this.gridDialogValidator::isReverseDialogCandidate).map(this::toDialogType).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(DialogType.UNKNOWN);
    }

    private Optional<DialogType> toDialogType(Field field) {
        return this.dialogTypeEvaluators.stream().filter(evaluator -> evaluator.evaluate(field)).findFirst().map(DialogTypeEvaluator::getType);
    }

    private boolean getMatchingField(Field field, Class<?> expectedType) {
        boolean result = field.getType().equals(expectedType);
        if (field.getType().isAssignableFrom(Collection.class) || field.getType().isAssignableFrom(Set.class) || field.getType().isAssignableFrom(List.class)) {
            Class<?> actualType = this.getGenericType(field);
            result = expectedType.equals(actualType);
        }
        return result;
    }

    private Class<?> getGenericType(Field field) {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    public DialogTypeDecider(FieldCollector fieldCollector, GridDialogValidator gridDialogValidator, List<DialogTypeEvaluator> dialogTypeEvaluators) {
        this.fieldCollector = fieldCollector;
        this.gridDialogValidator = gridDialogValidator;
        this.dialogTypeEvaluators = dialogTypeEvaluators;
    }
}

