/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.MenuGroup;
import io.overcoded.grid.annotation.GridMenu;
import io.overcoded.grid.processor.MenuGroupFactory;
import io.overcoded.grid.processor.ReflectionsFactory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuGroupCollector {
    private static final Logger log = LoggerFactory.getLogger(MenuGroupCollector.class);
    private final ReflectionsFactory reflectionsFactory;
    private final MenuGroupFactory menuGroupFactory;

    public List<MenuGroup> collect(String basePackage, String pathPrefix) {
        log.debug("Collecting menu groups for {} under {}", (Object)basePackage, (Object)pathPrefix);
        Reflections reflections = this.reflectionsFactory.create(basePackage);
        List<MenuGroup> result = reflections.getTypesAnnotatedWith(GridMenu.class).stream().map(type -> this.menuGroupFactory.create((Class<?>)type, pathPrefix)).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        log.trace("Collected menu groups: {}", result);
        return result;
    }

    public MenuGroupCollector(ReflectionsFactory reflectionsFactory, MenuGroupFactory menuGroupFactory) {
        this.reflectionsFactory = reflectionsFactory;
        this.menuGroupFactory = menuGroupFactory;
    }
}

