/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.MenuEntry;
import io.overcoded.grid.annotation.GridView;
import io.overcoded.grid.processor.column.NameTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuEntryFactory {
    private static final Logger log = LoggerFactory.getLogger(MenuEntryFactory.class);
    private final NameTransformer nameTransformer;

    public MenuEntry create(Class<?> type, String pathPrefix) {
        if (!type.isAnnotationPresent(GridView.class)) {
            throw new IllegalArgumentException("Input class should be annotated with GridView.");
        }
        log.debug("Creating menu entry for {} under {}", (Object)type.getName(), (Object)pathPrefix);
        GridView source = type.getAnnotation(GridView.class);
        return MenuEntry.builder().type(type).icon(source.icon()).order(source.order()).entries(new ArrayList<MenuEntry>()).grouped(source.grouping()).path(pathPrefix + source.path()).label(this.nameTransformer.transformPath(this.getFinalPathSegment(source))).enabledFor(List.of(source.enabledFor())).build();
    }

    public MenuEntry create(io.overcoded.grid.annotation.MenuEntry entry) {
        MenuEntry result = null;
        if (Objects.nonNull(entry.href())) {
            String url = this.hasValidUrl(entry) ? entry.href().url() : null;
            result = MenuEntry.builder().icon(entry.icon()).order(entry.order()).configuration(entry.config()).enabledFor(List.of(entry.enabledFor())).label(entry.label()).entries(List.of()).path(url).build();
        }
        return result;
    }

    private boolean hasValidUrl(io.overcoded.grid.annotation.MenuEntry entry) {
        return Objects.nonNull(entry.href().url()) && !entry.href().url().isBlank();
    }

    private String getFinalPathSegment(GridView source) {
        return source.path().substring(source.path().lastIndexOf("/") + 1);
    }

    public MenuEntryFactory(NameTransformer nameTransformer) {
        this.nameTransformer = nameTransformer;
    }
}

