/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.GridMenuGroup;
import io.overcoded.grid.GridMenuItem;
import io.overcoded.grid.annotation.MenuGroup;
import io.overcoded.grid.annotation.MenuGroups;
import io.overcoded.grid.processor.GridMenuEntryCollector;
import io.overcoded.grid.processor.GridMenuGroupFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GridMenuGroupCollector {
    private final GridMenuGroupFactory groupFactory;
    private final GridMenuEntryCollector gridMenuEntryCollector;

    public Map<String, GridMenuGroup> collect(Class<?> type) {
        Map<String, GridMenuGroup> emptyGroups = this.getEmptyGroups(type);
        return this.getMenuGroups(emptyGroups, type);
    }

    private Map<String, GridMenuGroup> getMenuGroups(Map<String, GridMenuGroup> menuGroups, Class<?> type) {
        List<GridMenuItem> menuItems = this.gridMenuEntryCollector.collect(type);
        for (GridMenuItem menuItem : menuItems) {
            GridMenuGroup group;
            String key = Objects.nonNull(menuItem.getGroup()) ? menuItem.getGroup() : "";
            GridMenuGroup gridMenuGroup = group = menuGroups.containsKey(key) ? menuGroups.get(key) : this.getAliasGroup(menuGroups, key);
            if (Objects.isNull(group.getItems())) {
                group.setItems(new ArrayList<GridMenuItem>());
            }
            group.getItems().add(menuItem);
        }
        menuGroups.values().stream().map(GridMenuGroup::getItems).forEach(Collections::sort);
        return menuGroups;
    }

    private GridMenuGroup getAliasGroup(Map<String, GridMenuGroup> menuGroups, String key) {
        return menuGroups.values().stream().filter(group -> group.getAliasFor().contains(key)).findFirst().orElseGet(() -> (GridMenuGroup)menuGroups.get(""));
    }

    private Map<String, GridMenuGroup> getEmptyGroups(Class<?> type) {
        Map<Object, Object> groups = new TreeMap();
        if (type.isAnnotationPresent(MenuGroup.class)) {
            groups = this.extract((MenuGroup[])type.getAnnotationsByType(MenuGroup.class));
        } else if (type.isAnnotationPresent(MenuGroups.class)) {
            groups = this.extract(type.getAnnotation(MenuGroups.class).value());
        }
        if (!groups.containsKey("")) {
            groups.put("", GridMenuGroup.builder().order(Integer.MIN_VALUE).items(new ArrayList<GridMenuItem>()).aliasFor(Set.of()).build());
        }
        return groups;
    }

    private Map<String, GridMenuGroup> extract(MenuGroup[] menuGroups) {
        return Arrays.stream(menuGroups).map(this.groupFactory::create).sorted().collect(Collectors.toMap(GridMenuGroup::getName, Function.identity(), (first, second) -> first, TreeMap::new));
    }

    public GridMenuGroupCollector(GridMenuGroupFactory groupFactory, GridMenuEntryCollector gridMenuEntryCollector) {
        this.groupFactory = groupFactory;
        this.gridMenuEntryCollector = gridMenuEntryCollector;
    }
}

