/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.DialogGridMenuItem;
import io.overcoded.grid.GridMenuItem;
import io.overcoded.grid.LinkGridMenuItem;
import io.overcoded.grid.annotation.GridDialog;
import io.overcoded.grid.annotation.MenuEntry;
import io.overcoded.grid.annotation.WithCustomFilter;
import io.overcoded.grid.processor.column.JoinFieldFinder;
import io.overcoded.grid.processor.column.NameTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridMenuEntryFactory {
    private static final Logger log = LoggerFactory.getLogger(GridMenuEntryFactory.class);
    private final JoinFieldFinder joinFieldFinder;
    private final NameTransformer nameTransformer;

    public GridMenuItem create(MenuEntry menuEntry) {
        GridMenuItem result = null;
        if (this.isLinkGridMenuItem(menuEntry)) {
            result = this.createLinkGridMenuItem(menuEntry);
        }
        return result;
    }

    private boolean isLinkGridMenuItem(MenuEntry menuEntry) {
        return Objects.nonNull(menuEntry.href().url()) && !menuEntry.href().url().isBlank() || Objects.nonNull(menuEntry.href().method()) && !menuEntry.href().method().isBlank() && !"DEFAULT".equals(menuEntry.href().method());
    }

    public GridMenuItem create(Field field, Class<?> parentType) {
        return this.create(field, this.getGenericType(field), parentType);
    }

    public GridMenuItem create(Field field, Class<?> genericType, Class<?> parentType) {
        GridMenuItem result = null;
        if (genericType.isAnnotationPresent(GridDialog.class)) {
            GridDialog dialog = genericType.getAnnotation(GridDialog.class);
            result = ((DialogGridMenuItem.DialogGridMenuItemBuilder)this.createDialogGridMenuItem(field, genericType, parentType).description(dialog.description())).build();
            this.updateEnabledFor((DialogGridMenuItem)result, dialog);
        }
        return result;
    }

    private String getConfiguration(MenuEntry entry) {
        return "DEFAULT".equals(entry.href().config()) ? entry.config() : entry.href().config();
    }

    private GridMenuItem createLinkGridMenuItem(MenuEntry entry) {
        String method = this.hasValidMethod(entry) ? entry.href().method() : null;
        return ((LinkGridMenuItem.LinkGridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((GridMenuItem.GridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((GridMenuItem.GridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)((LinkGridMenuItem.LinkGridMenuItemBuilder)LinkGridMenuItem.builder().method(method)).icon(entry.icon())).order(entry.order())).label(entry.label())).divided(entry.divided())).link(entry.href().url())).target(entry.href().target())).group(entry.menuGroup())).arguments(List.of(entry.href().args()))).enabledFor(List.of(entry.enabledFor()))).configuration(this.getConfiguration(entry))).build();
    }

    private DialogGridMenuItem.DialogGridMenuItemBuilder<?, ?> createDialogGridMenuItem(Field field, Class<?> genericType, Class<?> parentType) {
        DialogGridMenuItem.DialogGridMenuItemBuilder<?, ?> builder = DialogGridMenuItem.builder();
        builder = genericType.isAnnotationPresent(MenuEntry.class) ? this.withEntry(field, genericType.getAnnotation(MenuEntry.class)) : this.withoutEntry(field, genericType.getAnnotation(GridDialog.class));
        return ((DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)builder.type(genericType)).customFilter(this.hasCustomFilter(field))).name(this.getName(genericType, parentType))).parentFieldName(this.getParentFieldName(field));
    }

    private DialogGridMenuItem.DialogGridMenuItemBuilder<?, ?> withEntry(Field field, MenuEntry entry) {
        return (DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)DialogGridMenuItem.builder().icon(entry.icon())).order(entry.order())).divided(entry.divided())).label(this.getLabel(field, entry))).group(entry.menuGroup())).enabledFor(List.of(entry.enabledFor()));
    }

    private DialogGridMenuItem.DialogGridMenuItemBuilder<?, ?> withoutEntry(Field field, GridDialog dialog) {
        return (DialogGridMenuItem.DialogGridMenuItemBuilder)((DialogGridMenuItem.DialogGridMenuItemBuilder)((GridMenuItem.GridMenuItemBuilder)DialogGridMenuItem.builder().description(dialog.description())).label(this.getLabel(field, null))).enabledFor(List.of(dialog.enabledFor()));
    }

    private String getLabel(Field field, MenuEntry entry) {
        return this.hasLabel(entry) ? entry.label() : this.nameTransformer.transform(field);
    }

    private boolean hasLabel(MenuEntry entry) {
        return Objects.nonNull(entry) && Objects.nonNull(entry.label()) && !entry.label().isBlank();
    }

    private String getName(Class<?> genericType, Class<?> parentType) {
        Field joinField = this.joinFieldFinder.find(genericType, parentType);
        return Objects.nonNull(joinField) ? joinField.getName() : null;
    }

    private String getParentFieldName(Field field) {
        String parentFieldName = null;
        if (this.hasCustomFilter(field)) {
            parentFieldName = field.getAnnotation(WithCustomFilter.class).value();
        }
        return parentFieldName;
    }

    private boolean hasValidMethod(MenuEntry entry) {
        return Objects.nonNull(entry.href().method()) && !"DEFAULT".equals(entry.href().method());
    }

    private boolean hasCustomFilter(Field field) {
        return field.isAnnotationPresent(WithCustomFilter.class);
    }

    private void updateEnabledFor(DialogGridMenuItem result, GridDialog dialog) {
        HashSet<String> enabledFor = Objects.nonNull(result.getEnabledFor()) ? new HashSet<String>(result.getEnabledFor()) : new HashSet();
        enabledFor.addAll(List.of(dialog.enabledFor()));
        result.setEnabledFor(new ArrayList<String>(enabledFor));
    }

    private Class<?> getGenericType(Field field) {
        Class result = field.getType();
        if (field.getType().isAssignableFrom(Collection.class) || field.getType().isAssignableFrom(Set.class) || field.getType().isAssignableFrom(List.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            result = (Class)actualTypeArguments[0];
        }
        return result;
    }

    public GridMenuEntryFactory(JoinFieldFinder joinFieldFinder, NameTransformer nameTransformer) {
        this.joinFieldFinder = joinFieldFinder;
        this.nameTransformer = nameTransformer;
    }
}

