package io.overcoded.grid.processor.dialog;

import io.overcoded.grid.DialogType;

import java.lang.reflect.Field;

/**
 * DialogTypeEvaluator is an interface to determinate dialog types based on annotations on field.
 * Implementation should exist most of the field provider types.
 */
public interface DialogTypeEvaluator {
    /**
     * Returns the corresponding DialogType of the evaluator
     *
     * @return the dialog type which should apply if test(Field) true
     */
    DialogType getType();

    /**
     * Checks that the field belongs to the specified dialog type or not
     *
     * @param field which should be examined
     * @return true when the field can be the specified dialog type.
     */
    boolean evaluate(Field field);
}
