package io.overcoded.grid.processor;

import io.overcoded.grid.GridMenuItem;
import io.overcoded.grid.annotation.MenuEntry;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@RequiredArgsConstructor
public class GridMenuEntryCollector {
    private final FieldCollector fieldCollector;
    private final GridDialogValidator gridDialogValidator;
    private final GridMenuEntryFactory gridMenuEntryFactory;

    public List<GridMenuItem> collect(Class<?> type) {
        List<GridMenuItem> result = new ArrayList<>();
        result.addAll(collectDialogGridMenuItem(type));
        result.addAll(collectCustomGridMenuItem(type));
        return result.stream().sorted().collect(Collectors.toList());
    }

    private List<GridMenuItem> collectDialogGridMenuItem(Class<?> type) {
        return fieldCollector.getFields(type).stream()
                .filter(gridDialogValidator::isDialogCandidate)
                .map(field -> gridMenuEntryFactory.create(field, type))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
    }

    private List<GridMenuItem> collectCustomGridMenuItem(Class<?> type) {
        List<GridMenuItem> result = Arrays.stream(type.getAnnotationsByType(MenuEntry.class))
                .map(gridMenuEntryFactory::create)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        return result;
    }

}
