package io.overcoded.grid.processor;

import io.overcoded.grid.GridInfo;

import java.lang.annotation.Annotation;

/**
 * Creates a GridInfo from a type which is annotated with the specified annotation.
 * <p>
 * Currently two implementation planned:
 *   - GridView
 *   - GridDialog
 * @param <T> annotation which should be present on type which is under processing.
 */
public interface GridInfoFactory<T extends Annotation> {
    /**
     * Corresponding annotation type
     * @return expected annotation on input type of create method.
     */
    Class<T> getSourceType();

    /**
     * Creates a GridInfo instance based on the input type GridView or a GridDialog annotation.
     * It also sets the columns and groups for the GridInfo.
     *
     * @param type the type which should be transformed into GridInfo
     * @return a GridInfo instance
     * @throws IllegalArgumentException when type is not annotated with GridView or GridDialog
     */
    GridInfo create(Class<?> type);
}
