package io.overcoded.grid.processor;

import lombok.RequiredArgsConstructor;

import java.lang.reflect.Field;
import java.util.*;

/**
 * Collects all the available fields in a class.
 */
@RequiredArgsConstructor
public class FieldCollector {
    /**
     * This method collects all the declared fields in a type.
     * It also checks its ancestors until Object.
     *
     * @param type which should be crawled
     * @return Set of available fields
     */
    public Set<Field> getFields(Class<?> type) {
        Map<String, Field> fields = new HashMap<>();

        Class<?> currentType = type;
        while (Objects.nonNull(currentType.getSuperclass())) {
            Arrays.stream(currentType.getDeclaredFields())
                    .forEach(field -> fields.putIfAbsent(field.getName(), field));
            currentType = currentType.getSuperclass();
        }

        return new HashSet<>(fields.values());
    }
}
