package io.overcoded.grid;

import java.util.function.Supplier;

/**
 * PickerFactory is an interface responsible to collect those classes
 * which are responsible to produce Picker instances.
 *
 * @param <T> type which handled by the specified picker
 */
public interface PickerFactory<T> extends Supplier<Picker<T>> {
    /**
     * Returns the type of the Picker.
     *
     * @return type bound to Picker
     */
    Class<T> getType();
}
