package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Defines the menu layout of the system.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MenuLayout {
    /**
     * Root package of the system
     */
    private Class<?> type;

    /**
     * Icon for the system.
     */
    private String logo;

    /**
     * Title (or the name) of the system
     */
    private String title;

    /**
     * List of menu groups on the system
     */
    private List<MenuGroup> groups;
}
