package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.FieldProviderType;

import java.lang.reflect.Field;

/**
 * Implementation should exist most of the field provider types.
 */
public interface FieldProviderTypeEvaluator {
    /**
     * Returns the corresponding FieldProviderType of the evaluator
     * <p>
     * One FieldProviderType can have multiple evaluators.
     *
     * @return the field provider type which should apply if test(Field) true
     */
    FieldProviderType getType();

    /**
     * Checks that the field belongs to the specified field provider type or not
     *
     * @param field which should be examined
     * @return true when the field can be the specified field provider type.
     */
    boolean evaluate(Field field);

    /**
     * To prevent overlapping evaluation should happen in sequel based on this order.
     * Order only required when overlapping can happen.
     *
     * @return order
     */
    int getOrder();
}
