package io.overcoded.grid.processor;

import io.overcoded.grid.MenuEntry;

import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * SubmenuEntryCollector responsible to collect submenus for menu entries.
 */
public class SubmenuEntryCollector {
    /**
     * Collects the submenus belong to menu entry.
     *
     * @param menuEntry the parent menu entry
     * @param submenus  submenu entries
     * @return list of submenus of the entry
     */
    public List<MenuEntry> collect(MenuEntry menuEntry, List<MenuEntry> submenus) {
        return submenus.stream()
                .filter(submenu -> submenu.getPath().startsWith(menuEntry.getPath()))
                .sorted()
                .collect(toList());
    }
}
