package io.overcoded.grid.processor;

import io.overcoded.grid.GridMenuGroup;
import io.overcoded.grid.annotation.MenuGroup;

import java.util.ArrayList;

import static java.util.Arrays.stream;
import static java.util.stream.Collectors.toSet;

public class GridMenuGroupFactory {
    public GridMenuGroup create(MenuGroup group) {
        return GridMenuGroup.builder()
                .icon(group.icon())
                .name(group.name())
                .divided(group.divided())
                .order(group.order())
                .items(new ArrayList<>())
                .aliasFor(stream(group.aliasOf()).collect(toSet()))
                .build();
    }
}
