package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public abstract class GridMenuItem implements Comparable<GridMenuItem> {
    private int order;
    private String icon;
    private String label;
    private String group;
    private boolean divided;
    private String method;
    private String configuration;
    private List<String> enabledFor;

    @Override
    public int compareTo(GridMenuItem other) {
        return Integer.compare(order, other.order);
    }
}
