/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.MenuEntry;
import io.overcoded.grid.MenuGroup;
import io.overcoded.grid.annotation.GridMenu;
import io.overcoded.grid.processor.MenuEntryCollector;
import io.overcoded.grid.processor.column.NameTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuGroupFactory {
    private static final Logger log = LoggerFactory.getLogger(MenuGroupFactory.class);
    private final MenuEntryCollector menuEntryCollector;
    private final NameTransformer nameTransformer;

    public MenuGroup create(Class<?> type, String pathPrefix) {
        if (!type.isAnnotationPresent(GridMenu.class)) {
            throw new IllegalArgumentException("Input class should be annotated with GridMenu.");
        }
        log.debug("Creating menu group for {} under {}", (Object)type.getName(), (Object)pathPrefix);
        GridMenu source = type.getAnnotation(GridMenu.class);
        return MenuGroup.builder().type(type).icon(source.icon()).order(source.order()).label(this.getLabel(source)).path(pathPrefix + source.path()).enabledFor(List.of(source.enabledFor())).entries(this.getMenuEntries(type, pathPrefix, source)).build();
    }

    private List<MenuEntry> getMenuEntries(Class<?> type, String pathPrefix, GridMenu source) {
        ArrayList<MenuEntry> menuEntries = new ArrayList<MenuEntry>();
        menuEntries.addAll(this.menuEntryCollector.collect(type.getPackageName(), pathPrefix + source.path()));
        menuEntries.addAll(this.menuEntryCollector.collect(type));
        return menuEntries.stream().sorted().collect(Collectors.toList());
    }

    private String getLabel(GridMenu source) {
        return source.label().isBlank() ? this.nameTransformer.transformPath(this.getFinalPathSegment(source)) : source.label();
    }

    private String getFinalPathSegment(GridMenu source) {
        return source.path().substring(source.path().lastIndexOf("/") + 1);
    }

    public MenuGroupFactory(MenuEntryCollector menuEntryCollector, NameTransformer nameTransformer) {
        this.menuEntryCollector = menuEntryCollector;
        this.nameTransformer = nameTransformer;
    }
}

