/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ColumnInfo;
import io.overcoded.grid.GridInfo;
import io.overcoded.grid.GridMenuGroup;
import io.overcoded.grid.annotation.GridDialog;
import io.overcoded.grid.processor.ColumnInfoCollector;
import io.overcoded.grid.processor.GridInfoFactory;
import io.overcoded.grid.processor.GridMenuGroupCollector;
import io.overcoded.grid.processor.column.NameTransformer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridInfoDialogFactory
implements GridInfoFactory<GridDialog> {
    private static final Logger log = LoggerFactory.getLogger(GridInfoDialogFactory.class);
    private final Map<Class<?>, GridInfo> typeCache = new ConcurrentHashMap();
    private final NameTransformer nameTransformer;
    private final ColumnInfoCollector columnInfoCollector;
    private final GridMenuGroupCollector gridMenuGroupCollector;

    @Override
    public Class<GridDialog> getSourceType() {
        return GridDialog.class;
    }

    @Override
    public GridInfo create(Class<?> type) {
        if (!type.isAnnotationPresent(this.getSourceType())) {
            throw new IllegalArgumentException("GridDialog annotation must present on input type.");
        }
        return this.typeCache.computeIfAbsent(type, this::createGridInfo);
    }

    private GridInfo createGridInfo(Class<?> type) {
        log.debug("Creating grid info for {}", (Object)type.getName());
        GridDialog source = type.getAnnotation(this.getSourceType());
        List<ColumnInfo> columns = this.columnInfoCollector.collect(type);
        Map<String, GridMenuGroup> menuGroups = this.gridMenuGroupCollector.collect(type);
        String name = this.nameTransformer.transform(type.getSimpleName());
        return GridInfo.builder().enabledMethods(List.of(source.enabledMethods())).enabledFor(List.of(source.enabledFor())).sourceAnnotation(this.getSourceType()).description(source.description()).formEnabled(!source.hideForm()).menuGroups(menuGroups).columns(columns).type(type).name(name).build();
    }

    public GridInfoDialogFactory(NameTransformer nameTransformer, ColumnInfoCollector columnInfoCollector, GridMenuGroupCollector gridMenuGroupCollector) {
        this.nameTransformer = nameTransformer;
        this.columnInfoCollector = columnInfoCollector;
        this.gridMenuGroupCollector = gridMenuGroupCollector;
    }
}

