/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import java.lang.reflect.Field;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class GridDialogValidator {
    public boolean isDialogCandidate(Field field) {
        return this.isOneToMany(field) || this.isManyToMany(field) || this.isOneToOne(field);
    }

    public boolean isReverseDialogCandidate(Field field) {
        return this.isManyToOne(field) || this.isOneToOneOwner(field);
    }

    private boolean isManyToMany(Field field) {
        return field.isAnnotationPresent(ManyToMany.class);
    }

    private boolean isOneToMany(Field field) {
        return field.isAnnotationPresent(OneToMany.class);
    }

    private boolean isManyToOne(Field field) {
        return field.isAnnotationPresent(ManyToOne.class);
    }

    private boolean isOneToOne(Field field) {
        boolean result = false;
        if (field.isAnnotationPresent(OneToOne.class)) {
            result = this.hasMappedBy(field);
        }
        return result;
    }

    private boolean isOneToOneOwner(Field field) {
        boolean result = false;
        if (field.isAnnotationPresent(OneToOne.class)) {
            result = !this.hasMappedBy(field);
        }
        return result;
    }

    private boolean hasMappedBy(Field field) {
        return !field.getAnnotation(OneToOne.class).mappedBy().isBlank();
    }
}

