package io.overcoded.grid.processor.dialog;

import io.overcoded.grid.DialogType;

import javax.persistence.ManyToOne;
import java.lang.reflect.Field;

/**
 * DialogTypeEvaluator for REVERSE_MANY_TO_ONE_DIALOG instance of DialogType.
 */
public class ReverseManyToOneDialogTypeEvaluator implements DialogTypeEvaluator {
    /**
     * The DialogType instance bound to this evaluator.
     *
     * @return REVERSE_MANY_TO_ONE_DIALOG
     */
    @Override
    public DialogType getType() {
        return DialogType.REVERSE_MANY_TO_ONE_DIALOG;
    }

    /**
     * A Dialog belonging to Field can be one to many dialog when the field is
     * annotated with @ManyToOne.
     *
     * @param field which should be examined
     * @return true when the conditions met, false otherwise.
     */
    @Override
    public boolean evaluate(Field field) {
        return field.isAnnotationPresent(ManyToOne.class);
    }
}
