package io.overcoded.grid.processor.dialog;

import io.overcoded.grid.DialogType;

import javax.persistence.OneToMany;
import java.lang.reflect.Field;

/**
 * DialogTypeEvaluator for ONE_TO_MANY_DIALOG instance of DialogType.
 */
public class OneToManyDialogTypeEvaluator implements DialogTypeEvaluator {
    /**
     * The DialogType instance bound to this evaluator.
     *
     * @return ONE_TO_MANY_DIALOG
     */
    @Override
    public DialogType getType() {
        return DialogType.ONE_TO_MANY_DIALOG;
    }

    /**
     * A Dialog belonging to Field can be one to many dialog only when
     * the field is annotated with @OneToMany.
     *
     * @param field which should be examined
     * @return true when the conditions met, false otherwise.
     */
    @Override
    public boolean evaluate(Field field) {
        return field.isAnnotationPresent(OneToMany.class);
    }
}
