package io.overcoded.grid;

import io.overcoded.grid.annotation.GridMethod;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

/**
 * GridInfo contains the most important info to be able to generate
 * the corresponding grid for the type.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GridInfo {
    /**
     * Base type of the grid.
     */
    private Class<?> type;

    /**
     * Name of the grid, based on simple name of the type
     */
    private String name;

    /**
     * Annotation which is base of this GridInfo (GridDialog or GridView).
     * Combining it with the `type` of the GridInfo we can access the
     * annotation.
     */
    private Class<? extends Annotation> sourceAnnotation;

    /**
     * Information about the grid info
     */
    private String description;

    /**
     * List of the columns in the grid.
     * It also contains everything to be able to generate
     * a grid and the corresponding input element for the field.
     */
    private List<ColumnInfo> columns;

    /**
     * Configures that we should display form at all.
     */
    private boolean formEnabled;

    /**
     * Map of predefined grid menu groups
     */
    private Map<String, GridMenuGroup> menuGroups;

    /**
     * List of roles who can access this dialog.
     * <p>
     * Implementation can be different: the menu item can be disabled
     * or not even visible.
     */
    private List<String> enabledFor;

    /**
     * List of available methods. If the List is empty (or null) means
     * there is no restriction regarding the available methods.
     */
    private List<GridMethod> enabledMethods;
}
