package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Groups all the necessary information for generating a dialog
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DialogInfo {
    /**
     * Type which should be handled in dialog
     */
    private Class<?> type;

    /**
     * Type from where the dialog were opened.
     */
    private Class<?> parentType;

    /**
     * Grid info for the grid in the dialog.
     */
    private GridInfo gridInfo;

    /**
     * Rendering type of the Dialog, it mostly depends on the relationship
     * between parentType and type.
     */
    private DialogType renderingType;
}
