/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.FieldProvider;
import io.overcoded.grid.annotation.FieldProviderType;
import io.overcoded.grid.processor.column.FieldProviderTypeEvaluator;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

public class FieldProviderTypeDecider {
    private final List<FieldProviderTypeEvaluator> fieldProviderTypeEvaluators;

    public FieldProviderType decide(Field field, FieldProvider fieldProvider) {
        return Objects.isNull(fieldProvider) || fieldProvider.type() == FieldProviderType.DEFAULT ? this.calculateFieldProvider(field) : fieldProvider.type();
    }

    private FieldProviderType calculateFieldProvider(Field field) {
        return this.fieldProviderTypeEvaluators.stream().filter(evaluator -> evaluator.evaluate(field)).map(FieldProviderTypeEvaluator::getType).findFirst().orElse(FieldProviderType.DEFAULT);
    }

    public FieldProviderTypeDecider(List<FieldProviderTypeEvaluator> fieldProviderTypeEvaluators) {
        this.fieldProviderTypeEvaluators = fieldProviderTypeEvaluators;
    }
}

