/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.MenuLayout;
import io.overcoded.grid.annotation.GridSystem;
import io.overcoded.grid.processor.MenuGroupCollector;
import io.overcoded.grid.processor.ReflectionsFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuLayoutFactory {
    private static final Logger log = LoggerFactory.getLogger(MenuLayoutFactory.class);
    private final Map<Class<?>, MenuLayout> typeCache = new ConcurrentHashMap();
    private final ReflectionsFactory reflectionsFactory;
    private final MenuGroupCollector menuGroupCollector;

    public Optional<MenuLayout> create() {
        Reflections reflections = this.reflectionsFactory.create();
        return reflections.getTypesAnnotatedWith(GridSystem.class).stream().findFirst().map(this::convert);
    }

    private MenuLayout convert(Class<?> type) {
        return this.typeCache.computeIfAbsent(type, this::createMenuLayout);
    }

    private MenuLayout createMenuLayout(Class<?> type) {
        GridSystem gridSystem = type.getAnnotation(GridSystem.class);
        log.debug("Grid system found for {}", (Object)type.getName());
        MenuLayout result = MenuLayout.builder().type(type).logo(gridSystem.logo()).title(gridSystem.title()).groups(this.menuGroupCollector.collect(type.getPackageName(), gridSystem.path())).build();
        log.trace("Converted menu layout: {}", (Object)result);
        return result;
    }

    public MenuLayoutFactory(ReflectionsFactory reflectionsFactory, MenuGroupCollector menuGroupCollector) {
        this.reflectionsFactory = reflectionsFactory;
        this.menuGroupCollector = menuGroupCollector;
    }
}

