/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.FieldProviderType;
import io.overcoded.grid.annotation.GridColumn;
import io.overcoded.grid.processor.column.FieldProviderTypeEvaluator;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

public class FieldProviderTypeDecider {
    private final List<FieldProviderTypeEvaluator> fieldProviderTypeEvaluators;

    public FieldProviderType decide(Field field, GridColumn gridColumn) {
        return Objects.isNull(gridColumn) || gridColumn.fieldProviderType() == FieldProviderType.DEFAULT ? this.calculateFieldProvider(field) : gridColumn.fieldProviderType();
    }

    private FieldProviderType calculateFieldProvider(Field field) {
        return this.fieldProviderTypeEvaluators.stream().filter(evaluator -> evaluator.evaluate(field)).map(FieldProviderTypeEvaluator::getType).findFirst().orElse(FieldProviderType.DEFAULT);
    }

    public FieldProviderTypeDecider(List<FieldProviderTypeEvaluator> fieldProviderTypeEvaluators) {
        this.fieldProviderTypeEvaluators = fieldProviderTypeEvaluators;
    }
}

