/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.GridMenuGroup;
import io.overcoded.grid.GridMenuItem;
import io.overcoded.grid.annotation.MenuGroup;
import io.overcoded.grid.processor.GridMenuEntryCollector;
import io.overcoded.grid.processor.GridMenuGroupFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GridMenuGroupCollector {
    private final GridMenuGroupFactory groupFactory;
    private final GridMenuEntryCollector gridMenuEntryCollector;

    public Map<String, GridMenuGroup> collect(Class<?> type) {
        Map<String, GridMenuGroup> emptyGroups = this.getEmptyGroups(type);
        return this.getMenuGroups(emptyGroups, type);
    }

    private Map<String, GridMenuGroup> getMenuGroups(Map<String, GridMenuGroup> menuGroups, Class<?> type) {
        List<GridMenuItem> menuItems = this.gridMenuEntryCollector.collect(type);
        for (GridMenuItem menuItem : menuItems) {
            String key = Objects.nonNull(menuItem.getGroup()) ? menuItem.getGroup() : "";
            if (!menuGroups.containsKey(key)) continue;
            GridMenuGroup group = menuGroups.get(key);
            if (Objects.isNull(group.getItems())) {
                group.setItems(new ArrayList<GridMenuItem>());
            }
            group.getItems().add(menuItem);
        }
        menuGroups.values().stream().map(GridMenuGroup::getItems).forEach(Collections::sort);
        return menuGroups;
    }

    private Map<String, GridMenuGroup> getEmptyGroups(Class<?> type) {
        Map<String, GridMenuGroup> groups = new TreeMap<String, GridMenuGroup>();
        if (type.isAnnotationPresent(MenuGroup.class)) {
            groups = Arrays.stream((MenuGroup[])type.getAnnotationsByType(MenuGroup.class)).map(this.groupFactory::create).sorted().collect(Collectors.toMap(GridMenuGroup::getName, Function.identity(), (first, second) -> first, TreeMap::new));
        }
        groups.put("", GridMenuGroup.builder().order(Integer.MIN_VALUE).items(new ArrayList<GridMenuItem>()).build());
        return groups;
    }

    public GridMenuGroupCollector(GridMenuGroupFactory groupFactory, GridMenuEntryCollector gridMenuEntryCollector) {
        this.groupFactory = groupFactory;
        this.gridMenuEntryCollector = gridMenuEntryCollector;
    }
}

