/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.GridMenuItem;
import io.overcoded.grid.annotation.MenuEntry;
import io.overcoded.grid.processor.FieldCollector;
import io.overcoded.grid.processor.GridDialogValidator;
import io.overcoded.grid.processor.GridMenuEntryFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridMenuEntryCollector {
    private static final Logger log = LoggerFactory.getLogger(GridMenuEntryCollector.class);
    private final FieldCollector fieldCollector;
    private final GridDialogValidator gridDialogValidator;
    private final GridMenuEntryFactory gridMenuEntryFactory;

    public List<GridMenuItem> collect(Class<?> type) {
        ArrayList<GridMenuItem> result = new ArrayList<GridMenuItem>();
        result.addAll(this.collectDialogGridMenuItem(type));
        result.addAll(this.collectCustomGridMenuItem(type));
        return result.stream().sorted().collect(Collectors.toList());
    }

    private List<GridMenuItem> collectDialogGridMenuItem(Class<?> type) {
        return this.fieldCollector.getFields(type).stream().filter(this.gridDialogValidator::isDialogCandidate).map(field -> this.gridMenuEntryFactory.create((Field)field, type)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<GridMenuItem> collectCustomGridMenuItem(Class<?> type) {
        List<GridMenuItem> result = Arrays.stream((MenuEntry[])type.getAnnotationsByType(MenuEntry.class)).map(this.gridMenuEntryFactory::create).filter(Objects::nonNull).collect(Collectors.toList());
        return result;
    }

    public GridMenuEntryCollector(FieldCollector fieldCollector, GridDialogValidator gridDialogValidator, GridMenuEntryFactory gridMenuEntryFactory) {
        this.fieldCollector = fieldCollector;
        this.gridDialogValidator = gridDialogValidator;
        this.gridMenuEntryFactory = gridMenuEntryFactory;
    }
}

