/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ContextMenuEntry;
import io.overcoded.grid.annotation.GridDialog;
import io.overcoded.grid.annotation.WithCustomFilter;
import io.overcoded.grid.processor.column.JoinFieldFinder;
import io.overcoded.grid.processor.column.NameTransformer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuEntryFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextMenuEntryFactory.class);
    private final JoinFieldFinder joinFieldFinder;
    private final NameTransformer nameTransformer;

    public ContextMenuEntry create(Field field, Class<?> genericType, Class<?> parentType) {
        ContextMenuEntry columnInfo = null;
        log.debug("Creating context menu entry for {} in {}", (Object)field.getName(), (Object)parentType.getName());
        if (genericType.isAnnotationPresent(GridDialog.class)) {
            String joinFieldName;
            GridDialog gridDialog = genericType.getAnnotation(GridDialog.class);
            boolean customFilter = false;
            if (field.isAnnotationPresent(WithCustomFilter.class)) {
                customFilter = true;
                joinFieldName = field.getAnnotation(WithCustomFilter.class).value();
            } else {
                Field joinField = this.joinFieldFinder.find(genericType, parentType);
                joinFieldName = Objects.nonNull(joinField) ? joinField.getName() : null;
            }
            columnInfo = ContextMenuEntry.builder().type(genericType).name(joinFieldName).parentType(parentType).icon(gridDialog.icon()).order(gridDialog.order()).customFilter(customFilter).parentFieldName(field.getName()).description(gridDialog.description()).label(this.nameTransformer.transform(field)).enabledFor(Arrays.asList(gridDialog.enabledFor())).build();
        }
        return columnInfo;
    }

    public ContextMenuEntryFactory(JoinFieldFinder joinFieldFinder, NameTransformer nameTransformer) {
        this.joinFieldFinder = joinFieldFinder;
        this.nameTransformer = nameTransformer;
    }
}

