package io.overcoded.grid.processor.dialog;

import io.overcoded.grid.DialogType;

import javax.persistence.OneToOne;
import java.lang.reflect.Field;

/**
 * DialogTypeEvaluator for ONE_TO_ONE_DIALOG instance of DialogType.
 */
public class OneToOneDialogTypeEvaluator implements DialogTypeEvaluator {
    /**
     * The DialogType instance bound to this evaluator.
     *
     * @return ONE_TO_ONE_DIALOG
     */
    @Override
    public DialogType getType() {
        return DialogType.ONE_TO_ONE_DIALOG;
    }

    /**
     * A Dialog belonging to Field can be one to one dialog only when
     * the field is annotated with @OneToOne and the mappedBy attribute
     * is not blank.
     * Means the other side of the relationship owns the relationship.
     * @param field which should be examined
     * @return true when the conditions met, false otherwise.
     */
    @Override
    public boolean evaluate(Field field) {
        boolean result = false;
        if (field.isAnnotationPresent(OneToOne.class)) {
            result = !field.getAnnotation(OneToOne.class).mappedBy().isBlank();
        }
        return result;
    }
}
