package io.overcoded.grid.processor.column;

import io.overcoded.grid.PickerFactory;
import io.overcoded.grid.annotation.FieldProviderType;
import lombok.RequiredArgsConstructor;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

/**
 * FieldProviderTypeEvaluator for PICKER instance of FieldProviderType.
 */
@RequiredArgsConstructor
public class PickerFieldProviderTypeEvaluator implements FieldProviderTypeEvaluator {
    private final List<PickerFactory<?>> pickers;

    /**
     * The FieldProviderType instance bound to this evaluator.
     *
     * @return PICKER
     */
    @Override
    public FieldProviderType getType() {
        return FieldProviderType.PICKER;
    }

    /**
     * Tests that a field can be marked with PICKER FieldProviderType.
     *
     * @param field which should be examined
     * @return true if there is a Picker for type of the field, false otherwise
     */
    @Override
    public boolean evaluate(Field field) {
        return Objects.nonNull(field)
                && pickers.stream().anyMatch(picker -> Objects.equals(field.getType(), picker.getType()));
    }

    /**
     * As this field provider type depends on users custom implementation, this is
     * the most important one, so it should be the first, which evaluated.
     * <p>
     * It returns zero, not Integer.MIN_VALUE, to allow the users to define much
     * specified field provider type evaluators.
     *
     * @return 0
     */
    @Override
    public int getOrder() {
        return 0;
    }
}
