package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.DisplayValue;

import java.lang.reflect.Field;
import java.util.List;

/**
 * Extracts the display value expressions for a Field
 */
public class DisplayValueExpressionExtractor {
    /**
     * Extracts the expressions for a list of a field.
     *
     * @param field which should be tested.
     * @return List of expressions if DisplayValue annotation present (and non-empty) on field type, empty list otherwise.
     * @see DisplayValue
     */
    public List<String> extract(Field field) {
        List<String> result = List.of();
        if (field.getType().isAnnotationPresent(DisplayValue.class)) {
            DisplayValue displayValue = field.getType().getAnnotation(DisplayValue.class);
            result = List.of(displayValue.value());
        }
        return result;
    }
}
