package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.FieldProviderType;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.Objects;

/**
 * FieldProviderTypeEvaluator for DATE_PICKER instance of FieldProviderType.
 * Only fields declared as LocalDate should be considered as valid date picker.
 *
 */
public class DatePickerFieldProviderTypeEvaluator implements FieldProviderTypeEvaluator {
    /**
     * The FieldProviderType instance bound to this evaluator.
     * @return DATE_PICKER
     */
    @Override
    public FieldProviderType getType() {
        return FieldProviderType.DATE_PICKER;
    }

    /**
     * Tests that a field can be marked with DATE_PICKER FieldProviderType.
     * @param field which should be examined
     * @return true if the field declared as LocalDate, false otherwise
     */
    @Override
    public boolean evaluate(Field field) {
        return Objects.nonNull(field)
                && field.getType().isAssignableFrom(LocalDate.class);
    }

    /**
     * As this field provider type evaluator checks exact type matching, this
     * always can apply.
     * <p>
     * This implementation sends this evaluator in the end of the list, so if there
     * is a custom Picker implementation which can apply on LocalDate, that will
     * be selected.
     * @return Integer.MAX_VALUE
     */
    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}
