package io.overcoded.grid;

/**
 * Picker is a common interface on top of control elements.
 * Mostly used when a type has too many elements, and we want to tear it down.
 * <p>
 * E.g.: CityPicker enables a Country dropdown first and activate the City
 * dropdown once the country selected.
 *
 * @param <T> type which handled by the specified picker
 */
public interface Picker<T> {
    /**
     * Return the actual value of the Picker
     *
     * @return value
     */
    T getValue();

    /**
     * Sets the value to the picker
     *
     * @param value which should be applied on controller
     */
    void setValue(T value);
}
