package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Menu group is a package in the system which can contain
 * one or more menu entries.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MenuGroup implements Comparable<MenuGroup> {
    /**
     * Package associated with this menu group
     */
    private Class<?> type;

    /**
     * Icon of the menu group
     */
    private String icon;

    /**
     * The base path of the group. Each menu entry in the group
     * should start with this path prefix.
     */
    private String path;

    /**
     * Defines the label of the group in the menu
     */
    private String label;

    /**
     * Defines the order of the menu group
     */
    private int order;

    /**
     * List of menu entries in the group
     */
    private List<MenuEntry> entries;

    /**
     * List of roles who can access this dialog.
     * <p>
     * Implementation can be different: the menu group can be disabled
     * or not even visible.
     */
    private List<String> enabledFor;

    /**
     * Natural order of MenuGroups
     * @param other the object to be compared.
     * @return natural order based on order field
     */
    @Override
    public int compareTo(MenuGroup other) {
        return Integer.compare(order, other.order);
    }
}
