package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * GridMenuGroup (previously ContextMenuGroup) will be the new way have we are
 * grouping menu items in a Grid.
 * <p>
 * The name changed, because in the POC the concept of context menu has been
 * replaced with a menu bar in the table and because the original ContextMenuGroup
 * and ContextMenuEntry concentrated only for GridDialogs. But there are multiple
 * examples when we need a custom context menu.
 * <p>
 * One other reason to this change is that we've introduced ContextMenuGroup annotation,
 * so we can collect the context menu groups for the grid, and we only need to define
 * their names if we want to put a dialog there.
 * <p>
 * Basically GridMenuGroup is representing a ContextMenuGroup, with all it's menu entry.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GridMenuGroup implements Comparable<GridMenuGroup> {
    private int order;
    private String name;
    private String icon;
    private boolean divided;
    private List<GridMenuItem> items;

    @Override
    public int compareTo(GridMenuGroup other) {
        return Integer.compare(order, other.order);
    }
}
