package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class DialogGridMenuItem extends GridMenuItem {
    /**
     * Name of the field which should be filtered in the dialog.
     */
    private String name;

    /**
     * Type of the dialog.
     * <p>
     * If this is an entity type annotated with GridDialog or GridView
     * Which means the grid inside this dialog should handle this type.
     * <p>
     * In both cases the dialog should accept parent type as parameter.
     */
    private Class<?> type;

    /**
     * Name of the field in the parent class
     */
    private String parentFieldName;

    /**
     * Defines that the name is based on custom filter property,
     * means you need to take care of parameter type manually.
     */
    private boolean customFilter;

    /**
     * Description or information to display as a warning on the
     * top section of the dialog.
     */
    private String description;
}
