package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Defines a group of context menu on a grid
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Deprecated(since = "1.2.0", forRemoval = true)
public class ContextMenuGroup implements Comparable<ContextMenuGroup> {
    /**
     * Icon, which should be displayed for the group
     */
    private String icon;

    /**
     * Label of the group
     */
    private String label;

    /**
     * Order of the group
     */
    private int order;

    /**
     * List of menu entries in the group
     */
    private List<ContextMenuEntry> contextMenuEntries;

    @Override
    public int compareTo(ContextMenuGroup other) {
        return Integer.compare(order, other.order);
    }
}
