package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.FieldProviderType;

import java.lang.reflect.Field;
import java.time.LocalTime;
import java.util.Objects;

/**
 * FieldProviderTypeEvaluator for TIME_PICKER instance of FieldProviderType.
 * Only fields declared as LocalTime should be considered as valid date time picker.
 */
public class TimePickerFieldProviderTypeEvaluator implements FieldProviderTypeEvaluator {
    /**
     * The FieldProviderType instance bound to this evaluator.
     *
     * @return TIME_PICKER
     */
    @Override
    public FieldProviderType getType() {
        return FieldProviderType.TIME_PICKER;
    }

    /**
     * Tests that a field can be marked with TIME_PICKER FieldProviderType.
     *
     * @param field which should be examined
     * @return true if the field declared as LocalTime, false otherwise
     */
    @Override
    public boolean evaluate(Field field) {
        return Objects.nonNull(field)
                && field.getType().isAssignableFrom(LocalTime.class);
    }

    /**
     * As this field provider type evaluator checks exact type matching, this
     * always can apply.
     * <p>
     * This implementation sends this evaluator in the end of the list, so if there
     * is a custom Picker implementation which can apply on LocalTime, that will
     * be selected.
     *
     * @return Integer.MAX_VALUE
     */
    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}
