package io.overcoded.grid.processor.column;

import io.overcoded.grid.annotation.FieldProviderType;

import java.lang.reflect.Field;
import java.util.Objects;

/**
 * FieldProviderTypeEvaluator for ENUM instance of FieldProviderType.
 * Only enum fields should be considered as ENUM.
 */
public class EnumFieldProviderTypeEvaluator implements FieldProviderTypeEvaluator {
    /**
     * The FieldProviderType instance bound to this evaluator.
     *
     * @return ENUM
     */
    @Override
    public FieldProviderType getType() {
        return FieldProviderType.ENUM;
    }

    /**
     * Tests that a field can be marked with ENUM FieldProviderType.
     *
     * @param field which should be examined
     * @return true if the field which has enum type.
     */
    @Override
    public boolean evaluate(Field field) {
        return Objects.nonNull(field) && field.getType().isEnum();
    }

    /**
     * As this field provider type evaluator checks only for types which are enums,
     * the order doesn't really matter.
     * <p>
     * In some cases we may want to implement custom Picker for an enum, so this
     * evaluator should evaluate only after PickerFieldProviderTypeEvaluator.
     *
     * @return 100
     */
    @Override
    public int getOrder() {
        return 100;
    }
}
