package io.overcoded.grid.processor;

import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import java.lang.reflect.Field;

/**
 * Validates that one field can be grid dialog.
 */
public class GridDialogValidator {
    /**
     * Field only should be considered as dialog if one of the following criteria met:
     * - Field is annotated with @OneToMany annotation
     * - Field is annotated with @ManyToMany annotation
     * - Field is annotated with @OneToOne annotation and mapped by field has value,
     * @param field which should be checked
     * @return true if the field can be handled as dialog, false otherwise.
     */
    public boolean isDialogCandidate(Field field) {
        return isOneToMany(field) || isManyToMany(field) || isOneToOne(field);
    }

    private boolean isManyToMany(Field field) {
        return field.isAnnotationPresent(ManyToMany.class);
    }

    private boolean isOneToMany(Field field) {
        return field.isAnnotationPresent(OneToMany.class);
    }

    private boolean isOneToOne(Field field) {
        boolean result = false;
        if (field.isAnnotationPresent(OneToOne.class)) {
            OneToOne relationship = field.getAnnotation(OneToOne.class);
            result = !relationship.mappedBy().isBlank();
        }
        return result;
    }
}
