package io.overcoded.grid.processor;

import io.overcoded.grid.DialogInfo;
import io.overcoded.grid.processor.dialog.DialogTypeDecider;
import lombok.RequiredArgsConstructor;

/**
 * Creates a DialogInfo instance from type and the type which owns the type.
 */
@RequiredArgsConstructor
public class DialogInfoFactory {
    private final GridInfoDialogFactory gridInfoDialogFactory;
    private final DialogTypeDecider dialogTypeDecider;

    /**
     * Dialog info of a type
     * @param type which should be handled in the dialog
     * @param parentType the type where the dialog should pop up
     * @return DialogInfo instance
     * @throws IllegalArgumentException when type is not annotated with GridDialog
     */
    public DialogInfo create(Class<?> type, Class<?> parentType) {
        return DialogInfo.builder()
                .type(type)
                .parentType(parentType)
                .gridInfo(gridInfoDialogFactory.create(type))
                .renderingType(dialogTypeDecider.decide(type, parentType))
                .build();
    }
}
