package io.overcoded.grid;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MethodInfo {
    /**
     * Corresponding JpaRepository
     * Find method and count method should be available.
     */
    private JpaRepository<?, ?> repository;

    /**
     * Name of find method.
     */
    private String findMethodName;

    /**
     * Name of count method
     */
    private String countMethodName;

    /**
     * Argument types, containing only the filter arguments,
     * which means the special Pageable argument shouldn't
     * be part of this list.
     */
    private List<Class<?>> argumentTypes;
}
