package io.overcoded.grid;

/**
 * Enumeration of supported (or planned) dialog types.
 */
public enum DialogType {
    /**
     * Defines dialog for one-to-one relationship between entities.
     * <p>
     * One possible implementation of one to one dialogs when
     * the grid is hidden and only the form is available.
     */
    ONE_TO_ONE_DIALOG,

    /**
     * Defines dialog for one-to-many relationship between entities.
     * <p>
     * Normally grid is displaying and automatically filtering the
     * values belongs to the parent instance.
     */
    ONE_TO_MANY_DIALOG,

    /**
     * Defines dialog for many-to-many relationship between entities.
     * <p>
     * This kind of dialog may not provide support to add new instance
     * of the joined entity, but adding already existing one to the
     * filtered value of the parent instance.
     */
    MANY_TO_MANY_DIALOG,

    /**
     * Defines a dialog where the specified url displaying
     * embedded into an iframe.
     */
    EMBEDDED_DIALOG,

    /**
     * Means we are unable to determinate the type of the dialog.
     */
    UNKNOWN
}
