/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor.column;

import java.lang.reflect.Field;
import java.util.Objects;

public class NameTransformer {
    public String transform(Field field) {
        return this.transform(field.getName());
    }

    public String transformPath(String text) {
        return this.transform(text.replaceAll("[-_/]", " "));
    }

    public String transform(String text) {
        return this.splitCamelCase(this.capitalize(text));
    }

    private String splitCamelCase(String input) {
        return input.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public String capitalize(String input) {
        Object result = input;
        if (Objects.nonNull(input) && input.length() >= 1) {
            result = input.substring(0, 1).toUpperCase() + input.substring(1);
        }
        return result;
    }

    public String decapitalize(String input) {
        Object result = input;
        if (Objects.nonNull(input) && input.length() >= 1) {
            result = input.substring(0, 1).toUpperCase() + input.substring(1);
        }
        return result;
    }
}

