/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor.column;

import io.overcoded.grid.processor.FieldCollector;
import io.overcoded.grid.processor.column.NameTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class JoinFieldFinder {
    private final FieldCollector fieldCollector;
    private final NameTransformer nameTransformer;

    public Field find(Class<?> genericType, Class<?> parentType) {
        Set<Field> candidates = this.getCandidates(genericType, parentType);
        return this.findBest(candidates, parentType);
    }

    private Field findBest(Set<Field> candidates, Class<?> parentType) {
        return this.hasOneSingleCandidate(candidates) ? this.getAnyCandidate(candidates) : this.findMatching(candidates, parentType).orElseGet(() -> this.getAnyCandidate(candidates));
    }

    private Optional<Field> findMatching(Set<Field> candidates, Class<?> parentType) {
        String parentField = this.nameTransformer.decapitalize(parentType.getName());
        return candidates.stream().filter(field -> field.getName().equals(parentField)).findFirst();
    }

    private boolean hasOneSingleCandidate(Set<Field> candidates) {
        return candidates.size() == 1;
    }

    private Field getAnyCandidate(Set<Field> candidates) {
        return candidates.stream().findAny().orElse(null);
    }

    private Set<Field> getCandidates(Class<?> type, Class<?> filterType) {
        return this.fieldCollector.getFields(type).stream().filter(field -> filterType.equals(this.getGenericType((Field)field))).filter(field -> field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)).collect(Collectors.toSet());
    }

    private Class<?> getGenericType(Field field) {
        Class result = field.getType();
        if (field.getType().isAssignableFrom(Collection.class) || field.getType().isAssignableFrom(Set.class) || field.getType().isAssignableFrom(List.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            result = (Class)actualTypeArguments[0];
        }
        return result;
    }

    public JoinFieldFinder(FieldCollector fieldCollector, NameTransformer nameTransformer) {
        this.fieldCollector = fieldCollector;
        this.nameTransformer = nameTransformer;
    }
}

