/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ColumnInfo;
import io.overcoded.grid.MethodInfo;
import io.overcoded.grid.MethodInfoProperties;
import io.overcoded.grid.annotation.GridDialog;
import io.overcoded.grid.annotation.GridView;
import io.overcoded.grid.processor.column.NameTransformer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.support.Repositories;

public class MethodInfoFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodInfoFactory.class);
    private final Repositories repositories;
    private final NameTransformer nameTransformer;
    private final MethodInfoProperties methodInfoProperties;

    public MethodInfo create(Class<?> type, List<ColumnInfo> columns) {
        if (!type.isAnnotationPresent(GridDialog.class) && !type.isAnnotationPresent(GridView.class)) {
            throw new IllegalArgumentException("GridDialog or GridView annotation must present on input type.");
        }
        Optional repositoryBean = this.repositories.getRepositoryFor(type);
        MethodInfo result = null;
        if (repositoryBean.isPresent()) {
            JpaRepository repository = (JpaRepository)repositoryBean.get();
            List<ColumnInfo> filterColumns = columns.stream().filter(ColumnInfo::isFilter).collect(Collectors.toList());
            String countFallback = this.methodInfoProperties.getFallbackCountMethod();
            String findFallback = this.methodInfoProperties.getFallbackFindMethod();
            List<Class<?>> argumentTypes = this.getArgumentTypes(filterColumns);
            List<String> fieldNames = this.getFieldNames(filterColumns);
            if (columns.isEmpty()) {
                result = this.createMethodInfo(repository, findFallback, countFallback, List.of());
            } else {
                List<String> methods = this.getMethodCandidates(type, argumentTypes, fieldNames);
                String findMethodName = this.getFindMethodName(methods, findFallback);
                String countMethodName = this.getCountMethodName(methods, findMethodName, countFallback);
                result = this.createMethodInfo(repository, findMethodName, countMethodName, argumentTypes);
            }
        }
        return result;
    }

    private String getCountMethodName(List<String> methods, String findMethodName, String countFallback) {
        String countMethodName;
        String countMethodCandidate = findMethodName.replace(this.methodInfoProperties.getFindMethodPrefix(), this.methodInfoProperties.getCountMethodPrefix());
        if (!countMethodCandidate.equals(countMethodName = methods.stream().filter(method -> method.equals(countMethodCandidate)).findFirst().orElse(countFallback))) {
            log.warn("Matching count method not found for {}. You may missed to add @FindAllBy or @FindAll annotations.", (Object)findMethodName);
        }
        return countMethodName;
    }

    private String getFindMethodName(List<String> methods, String findFallback) {
        return methods.stream().filter(method -> method.startsWith(this.methodInfoProperties.getFindMethodPrefix())).findFirst().orElse(findFallback);
    }

    private List<String> getMethodCandidates(Class<?> entityType, List<Class<?>> argumentTypes, List<String> fieldNames) {
        return this.repositories.getRepositoryFor(entityType).stream().map(Object::getClass).flatMap(this::getMethodStream).filter(this::isValidFindAllOrCountAllCandidate).filter(method -> this.containsArgumentsInExactOrder(List.of(method.getParameterTypes()), argumentTypes)).map(Method::getName).filter(name -> this.containsFieldNamesInExactOrder((String)name, fieldNames)).collect(Collectors.toList());
    }

    private Stream<Method> getMethodStream(Class<?> repositoryType) {
        return Stream.of(repositoryType.getDeclaredMethods());
    }

    private boolean isValidFindAllOrCountAllCandidate(Method method) {
        return this.isCountMethod(method) || this.isFindMethod(method);
    }

    private boolean isCountMethod(Method method) {
        return method.getName().startsWith(this.methodInfoProperties.getCountMethodPrefix());
    }

    private boolean isFindMethod(Method method) {
        return method.getName().startsWith(this.methodInfoProperties.getFindMethodPrefix()) && this.isPageable(method);
    }

    private boolean isPageable(Method method) {
        List<Class<?>> parameterTypes = List.of(method.getParameterTypes());
        return parameterTypes.get(parameterTypes.size() - 1).equals(Pageable.class);
    }

    private List<String> getFieldNames(List<ColumnInfo> filterColumns) {
        return filterColumns.stream().map(ColumnInfo::getName).collect(Collectors.toList());
    }

    private List<Class<?>> getArgumentTypes(List<ColumnInfo> filterColumns) {
        List argumentTypes = filterColumns.stream().map(ColumnInfo::getType).collect(Collectors.toCollection(ArrayList::new));
        argumentTypes.add(Pageable.class);
        return argumentTypes;
    }

    private boolean containsArgumentsInExactOrder(List<Class<?>> methodArgumentTypes, List<Class<?>> expectedArgumentTypes) {
        int argumentSize;
        boolean result = false;
        int expectedSize = expectedArgumentTypes.size();
        if (expectedSize == (argumentSize = methodArgumentTypes.size()) || expectedSize == argumentSize + 1) {
            int i;
            for (i = 0; i < argumentSize && expectedArgumentTypes.get(i).equals(methodArgumentTypes.get(i)); ++i) {
            }
            result = i >= argumentSize;
        }
        return result;
    }

    private boolean containsFieldNamesInExactOrder(String name, List<String> fieldNames) {
        boolean matching = true;
        String separator = this.methodInfoProperties.getCommonPrefixSeparator();
        List argumentNames = fieldNames.stream().map(this.nameTransformer::capitalize).collect(Collectors.toList());
        String simplifiedName = name.substring(name.indexOf(separator) + separator.length());
        for (int i = 0; i < argumentNames.size() && matching; ++i) {
            if (!simplifiedName.startsWith((String)argumentNames.get(i))) {
                matching = false;
            }
            if (!matching) continue;
            if ((simplifiedName = simplifiedName.replaceFirst((String)argumentNames.get(i), "")).contains("And")) {
                simplifiedName = simplifiedName.substring(simplifiedName.indexOf("And") + 3);
                continue;
            }
            if (!simplifiedName.contains("Or")) continue;
            simplifiedName = simplifiedName.substring(simplifiedName.indexOf("Or") + 2);
        }
        return matching;
    }

    private MethodInfo createMethodInfo(JpaRepository<?, ?> repository, String findMethodName, String countMethodName, List<Class<?>> argumentTypes) {
        argumentTypes.remove(Pageable.class);
        return MethodInfo.builder().repository(repository).findMethodName(findMethodName).countMethodName(countMethodName).argumentTypes(argumentTypes).build();
    }

    public MethodInfoFactory(Repositories repositories, NameTransformer nameTransformer, MethodInfoProperties methodInfoProperties) {
        this.repositories = repositories;
        this.nameTransformer = nameTransformer;
        this.methodInfoProperties = methodInfoProperties;
    }
}

