/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.MenuEntry;
import io.overcoded.grid.annotation.GridView;
import io.overcoded.grid.processor.column.NameTransformer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuEntryFactory {
    private static final Logger log = LoggerFactory.getLogger(MenuEntryFactory.class);
    private final NameTransformer nameTransformer;

    public MenuEntry create(Class<?> type, String pathPrefix) {
        if (!type.isAnnotationPresent(GridView.class)) {
            throw new IllegalArgumentException("Input class should be annotated with GridView.");
        }
        log.debug("Creating menu entry for {} under {}", (Object)type.getName(), (Object)pathPrefix);
        GridView source = type.getAnnotation(GridView.class);
        return MenuEntry.builder().type(type).icon(source.icon()).order(source.order()).entries(new ArrayList<MenuEntry>()).grouped(source.grouping()).path(pathPrefix + source.path()).label(this.nameTransformer.transformPath(this.getFinalPathSegment(source))).enabledFor(List.of(source.enabledFor())).build();
    }

    private String getFinalPathSegment(GridView source) {
        return source.path().substring(source.path().lastIndexOf("/") + 1);
    }

    public MenuEntryFactory(NameTransformer nameTransformer) {
        this.nameTransformer = nameTransformer;
    }
}

