/*
 * Decompiled with CFR 0.152.
 */
package io.overcoded.grid.processor;

import io.overcoded.grid.ContextMenuEntry;
import io.overcoded.grid.ContextMenuGroup;
import io.overcoded.grid.processor.ContextMenuGroupFactory;
import io.overcoded.grid.processor.FieldCollector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuGroupCollector {
    private static final Logger log = LoggerFactory.getLogger(ContextMenuGroupCollector.class);
    private final FieldCollector fieldCollector;
    private final ContextMenuGroupFactory contextMenuGroupFactory;

    public List<ContextMenuGroup> collect(Class<?> type) {
        log.debug("Collecting context menu groups for {}", (Object)type.getName());
        List<ContextMenuGroup> result = this.fieldCollector.getFields(type).stream().map(field -> this.contextMenuGroupFactory.create((Field)field, type)).filter(Objects::nonNull).collect(Collectors.toMap(ContextMenuGroup::getLabel, Function.identity(), this::merge, HashMap::new)).values().stream().sorted().collect(Collectors.toList());
        log.trace("Collected context menu groups: {}", result);
        return result;
    }

    private ContextMenuGroup merge(ContextMenuGroup stored, ContextMenuGroup fresh) {
        ArrayList<ContextMenuEntry> storedMenuEntries = new ArrayList<ContextMenuEntry>(stored.getContextMenuEntries());
        storedMenuEntries.addAll(fresh.getContextMenuEntries());
        storedMenuEntries.sort(null);
        stored.setContextMenuEntries(storedMenuEntries);
        return stored;
    }

    public ContextMenuGroupCollector(FieldCollector fieldCollector, ContextMenuGroupFactory contextMenuGroupFactory) {
        this.fieldCollector = fieldCollector;
        this.contextMenuGroupFactory = contextMenuGroupFactory;
    }
}

